//
//  GHBodyBatteryInfo.h
//  Garmin Health
//
//  Created by Timar, Mihai on 14/12/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>


/**
 *  Body battery state values.
 */
typedef NS_ENUM(uint8_t, GHBodyBatteryState) {
    
    /** The received data contains indication that body battery is disabled */
    GHBodyBatteryStateInvalid = 0,
    
    /** The received data is based directly on measurements */
    GHBodyBatteryStateMeasured = 1,
    
    /** The received data is modeled (i.e. last period did not have sufficient data for measurement) */
    GHBodyBatteryStateModeled = 2,

    /** The received data was adjusted.  */
    GHBodyBatteryStateAdjusted = 3,
};

#pragma mark - 
/**
 * Body Battery information. Represents information found about remaining energy reserves.
 * This includes the indication that information will not be available.
 */
@interface GHBodyBatteryData : NSObject <NSCoding>

/** Value in range [0..100]. Can be null */
@property (nonatomic, readonly, nullable) NSNumber* value;

/** Status of the reading. See GHBodyBatteryState */
@property (nonatomic, readonly) GHBodyBatteryState status;

/** Timestamp of reading (UTC). Can be null */
@property (nonatomic, readonly, nullable) NSDate* timestamp;

/** NS_UNAVAILABLE */
+ (nonnull instancetype)new NS_UNAVAILABLE;

/** NS_UNAVAILABLE */
- (nonnull instancetype)init NS_UNAVAILABLE;

@end
